#include <stdio.h>
#include <stdlib.h>
#include <time.h>

long long int getFreeMem(void) {
    
    FILE *meminfo = fopen("/proc/meminfo", "r");
    
    unsigned long long int ramB = 0;
    unsigned long long int ramKB = 0;
    char buff[1024];
    
    if(meminfo == NULL)
    {
        return -1;
    }
    
    while(fgets(buff, sizeof(buff), meminfo))
    {
        if(sscanf(buff, "MemFree: %llu kB", &ramKB) == 1)
        {
            ramB = ramKB * 1024;
        }
    }
    
    if(fclose(meminfo))
    {
        return -1;
    }
    
    return (long long int)ramB;
}



int main() {
    
    long long int freeMem = getFreeMem();
    
    if(freeMem == -1)
        return -1;
    
    unsigned long long int size = freeMem / sizeof(unsigned long long int), i = 0;
    
    srand(time(NULL));
    
    unsigned long long int *block = malloc(size * sizeof(unsigned long long int));
    for(i = 0; i < size; i++)
        block[i] = rand() * 100;
    

    for(i = 0; i < size; i++){
        if(0 == i % 1000)   
            printf("BYTE N: %llu VAL-- %llu\n",i,block[i]);
    }
    scanf("%llu",&i);
    free(block);
    
    return 0;
}
